﻿//////////////////////////////////////////////
// JpgScan.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkImages
#include "../Enums/JpgComponentType.h"

#include "JpgHuffmanTable.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Internals --------------------------------

namespace nkImages::jpg
{
	struct JpgScanComponent final
	{
		JPG_COMPONENT_TYPE _type = (JPG_COMPONENT_TYPE)0 ;
		unsigned char _huffmanTableIndex = 0u ;
	} ;
}

/// Class ------------------------------------

namespace nkImages::jpg
{
	class JpgScan final
	{
		public :

			// Functions
			// Parsing
			static JpgScan parseFromMarker (const unsigned char* data, nkMemory::BufferCast<JpgHuffmanTable> huffmanTables) ;

		public :

			// Attributes
			nkMemory::BufferCast<JpgHuffmanTable> _huffmanTables ;
			nkMemory::BufferView<const unsigned char> _data ;

			unsigned char _componentCount = 0u ;
			JpgScanComponent _components [3] ;

			unsigned char _spectralStart = 0u ;
			unsigned char _spectralEnd = 0u ;
			unsigned char _approximationHigh = 0u ;
			unsigned char _approximationLow = 0u ;
	} ;
}